﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace IndianHealthService.BMXNet.Model
{
    /// <summary>
    /// An instance of these args are included with the ContextChanging event and this event
    /// is a CancelEventArgs subclass.  The Cancel property being set to True represents the desire
    /// to Veto the change so the patient (and potentially visit) does not change.  The Veto can be
    /// overriden by the framework so be prepared for the context to change even if you don't want it
    /// to.  
    /// </summary>
    public class ContextChangingArgs : CancelEventArgs
    {
        private bool _isVisitChange = false;

        /// <summary>
        /// Answer True if the visit is about to be changed.
        /// </summary>
        public bool IsVisitChange
        {
            get { return _isVisitChange; }
            set { _isVisitChange = value; }
        }
        private bool _isPatientChange = false;

        /// <summary>
        /// Answer True if the visit is about to be changed.
        /// </summary>
        public bool IsPatientChange
        {
            get { return _isPatientChange; }
            set { _isPatientChange = value; }
        }

        private Context _beforeContext = null;

        /// <summary>
        /// The current state of the Context.
        /// </summary>
        public Context BeforeContext
        {
            get { return _beforeContext; }
            set { _beforeContext = value; }
        }
    }
}
